﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Printing;

namespace DialogDemo
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void btnModal_Click(object sender, EventArgs e)
        {
            var info = new Info();

            info.UserName = "Jan";

            DialogResult result = info.ShowDialog();

            if (result == DialogResult.OK)
            {
                //string name = info.txtName.Text;
                string name = info.UserName;

                MessageBox.Show(name);
            }
        }

        private void btnModeless_Click(object sender, EventArgs e)
        {
            new About().Show();
        }

        private void btnPrint_Click(object sender, EventArgs e)
        {
            var printDlg = new PrintPreviewDialog
            {
                Document = new PrintDocument()
            };

            printDlg.Document.PrintPage +=
                (sdr, pea) =>
                {
                    var font = new Font(Font.FontFamily, 30);
                    var printText = "Drukuj stronę testową!";
                    SizeF size = pea.Graphics.MeasureString("Drukuj stronę testową!", font);

                    var location = new PointF
                    {
                        X = pea.PageBounds.Width / 2 - size.Width / 2,
                        Y = pea.PageBounds.Height / 2 - size.Height / 2
                    };

                    pea.Graphics.DrawString(
                        printText,
                        font,
                        Brushes.Black,
                        location);

                    pea.HasMorePages = false;
                };

            printDlg.ShowDialog();
        }
    }
}
